import java.util.HashMap;
import java.util.Iterator;

public class Steuerung
{

    private Sudoku sudoku;
    private static final String VERSION = "Version 1.4";
    
    private HashMap<Integer, SudokuDatenbank> alleGespeichertenSudokus; 
    
    

    private Benutzerschnittstelle benutzerschnittstelle;
    public Steuerung()
    {
        sudoku = new Sudoku();
        benutzerschnittstelle = new Benutzerschnittstelle(this, sudoku);
        spielablauf();
    }

    private void spielablauf()
    {
        boolean beendet = false;
        while (! beendet)
        {

        }
    }
    
    private void initialisiereSudokuDatenbank()
    {
        alleGespeichertenSudokus = new HashMap<Integer, SudokuDatenbank> ();
        alleGespeichertenSudokus.put(new Integer(1), new SudokuDatenbankSpiel1("Sudoku 1"));
        alleGespeichertenSudokus.put(new Integer(2), new SudokuDatenbankSpiel2("Sudoku 2"));
        alleGespeichertenSudokus.put(new Integer(3), new SudokuDatenbankSpiel3("Sudoku 3"));
    }

    public boolean spielIstGewonnen()
    {
        boolean richtig = testeObSudokuKorrektIst();
        boolean alleZahlenAusgefuellt = testeObAlleZahlenAusgefuelltSind();
        return (richtig && alleZahlenAusgefuellt);
    }

    public String gibVersion()
    {
        return VERSION;
    }
    
    public void initialisiereSudoku(int pNummer)
    {
        sudoku.initialisiereFeld (alleGespeichertenSudokus.get(new Integer(pNummer)).felderInitialisieren());
    }

    public int getZahlFeld (int pPositionX, int pPositionY)
    {
        return sudoku.gibZahl(pPositionX, pPositionY);
    }

    public void setzteZahl(int pPositionX, int pPositionY, int pWert)
    {
        sudoku.setzeZahl(pPositionX, pPositionY, pWert);
    }

    public boolean istSudokuInitialisiert()
    {
        if (sudoku == null)
        {
            return false;
        }

        if (sudoku.besitztFeld() == true)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public boolean testeObAlleZahlenAusgefuelltSind()
    {
        return Solver.testetesteObAlleZahlenAusgefuelltSind(sudoku.clone());
    }

    /**
     * es wird getestet, ob schon eine zahl mehrfach vorhanden ist.
     * @return true  wenn das sudoku noch keine doppelten Zahlen hat.
     */
    public boolean testeObSudokuKorrektIst()
    {
        return Solver.testeObSudokuKorrektIst(sudoku.clone()); 
    }

    //     public boolean istLoesbar()
    //     {
    //         boolean tmp = true;
    // 
    //         int [] zaehler = new int [81];
    //         for (int d = 0; d < zaehler.length; d++)
    //         {
    //             zaehler [d] = 1;
    //         }
    // 
    //         int index = 0;
    // 
    //         for (int x = 0; x < sudoku.gibSeitenLaenge(); x ++)
    //         {
    // 
    //             for (int y = 0; y < sudoku.gibSeitenLaenge(); y++)
    //             {
    //                 if (sudoku.veraenderbar(x, y))
    //                 {
    //                     sudoku.setzeZahl(x, y, zaehler [index]);
    //                 }
    //                 index ++;
    //             }
    //         }
    // 
    //         return tmp;
    //     }

}

